package ru.yandex.direct.hourglass.implementations;

import java.time.Instant;

import javax.annotation.Nullable;

import ru.yandex.direct.hourglass.TaskProcessingResult;

public class TaskProcessingResultImpl implements TaskProcessingResult {
    private final Instant lastFinishTime;
    private final Instant lastStartTime;
    private final Throwable exception;


    private TaskProcessingResultImpl(Instant lastFinishTime, Instant lastStartTime,
                                     @Nullable Throwable exception) {
        this.lastFinishTime = lastFinishTime;
        this.lastStartTime = lastStartTime;
        this.exception = exception;
    }

    @Override
    public String toString() {
        return "TaskProcessingResultImpl{" +
                "lastFinishTime=" + lastFinishTime +
                ", lastStartTime=" + lastStartTime +
                ", exception=" + exception +
                '}';
    }

    @Override
    public Instant lastFinishTime() {
        return lastFinishTime;
    }

    @Override
    public Instant lastStartTime() {
        return lastStartTime;
    }

    @Override
    @Nullable
    public Throwable lastException() {
        return exception;
    }

    public static TaskProcessingResultImplBuilder builder() {
        return new TaskProcessingResultImplBuilder();
    }

    public static final class TaskProcessingResultImplBuilder {
        private Instant lastFinishTime;
        private Instant lastStartTime;
        private Throwable exception;

        private TaskProcessingResultImplBuilder() {
        }

        public TaskProcessingResultImplBuilder withLastFinishTime(Instant lastFinishTime) {
            this.lastFinishTime = lastFinishTime;
            return this;
        }

        public TaskProcessingResultImplBuilder withLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public TaskProcessingResultImplBuilder withException(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public TaskProcessingResultImpl build() {
            if (lastFinishTime != null && lastStartTime != null && lastFinishTime.compareTo(lastStartTime) < 0) {
                throw new IllegalArgumentException(
                        "Finish time (" + lastFinishTime + ") occured before start time (" + lastStartTime + ")");
            }

            return new TaskProcessingResultImpl(lastFinishTime, lastStartTime, exception);
        }
    }
}
