package ru.yandex.direct.hourglass.implementations;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

import ru.yandex.direct.hourglass.TaskThreadPool;

public class TaskThreadPoolImpl implements TaskThreadPool {

    private final ThreadPoolExecutor jobsExecutionService;

    public TaskThreadPoolImpl(int nThreads, ThreadsHierarchy threadsHierarchy) {
        var workersFactory = threadsHierarchy.getWorkersThreadFactory();

        jobsExecutionService = new ThreadPoolExecutor(nThreads, nThreads,
                0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(nThreads), workersFactory);
    }

    @Override
    public int activeThreadsCount() {
        return jobsExecutionService.getActiveCount();
    }

    @Override
    public int availableThreadCount() {
        return jobsExecutionService.getMaximumPoolSize() - jobsExecutionService.getActiveCount();
    }

    @Override
    public void shutdown() {
        jobsExecutionService.shutdown();
    }

    @Override
    public int getPoolSize() {
        return jobsExecutionService.getMaximumPoolSize();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return jobsExecutionService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Consumer<Future<Void>> featureConsumer, Callable<Void> main) {
        FutureTask<Void> voidFutureTask = new FutureTask<>(main);
        featureConsumer.accept(voidFutureTask);
        jobsExecutionService.execute(voidFutureTask);
    }
}
