package ru.yandex.direct.hourglass.implementations.internal;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.MonitoringWriter;
import ru.yandex.direct.hourglass.storage.Job;
import ru.yandex.direct.hourglass.storage.JobStatus;
import ru.yandex.direct.hourglass.storage.PrimaryId;
import ru.yandex.direct.hourglass.storage.Storage;

import static ru.yandex.direct.hourglass.storage.JobStatus.EXPIRED;

public class ExpiredLocksRemover implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExpiredLocksRemover.class);
    private final Storage storage;
    private final InstanceId schedulerId;
    private final MonitoringWriter vitalSignsListener;

    public ExpiredLocksRemover(Storage storage, InstanceId schedulerId,
                               MonitoringWriter vitalSignsListener) {
        this.storage = storage;
        this.schedulerId = schedulerId;
        this.vitalSignsListener = vitalSignsListener;
    }

    Storage getStorage() {
        return storage;
    }

    InstanceId getInstanceId() {
        return schedulerId;
    }

    @Override
    public void run() {
        Collection<Job> expiredJobs = getStorage().find().whereJobStatus(EXPIRED).findJobs();

        for (Job job : expiredJobs) {
            logger.warn("{}: found expired job {}", getInstanceId(), job);
        }

        if (expiredJobs.isEmpty()) {
            return;
        }

        List<PrimaryId> primaryIds = expiredJobs.stream().map(Job::primaryId).collect(Collectors.toList());

        getStorage().update()
                .wherePrimaryIdIn(primaryIds)
                .whereJobStatus(JobStatus.EXPIRED)
                .setJobStatus(JobStatus.READY)
                .execute();

        vitalSignsListener.expiredJobsFixed(expiredJobs.size());
    }

}
