package ru.yandex.direct.hourglass.implementations.randomchoosers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import ru.yandex.direct.hourglass.RandomChooser;

public class SimpleRandomChooserImpl<T> implements RandomChooser<T> {
    @Override
    public List<T> choose(Collection<T> elements, int size) {
        List<T> shuffledList = new ArrayList<>(elements);
        Collections.shuffle(shuffledList);
        return shuffledList.subList(0, Math.min(size, shuffledList.size()));
    }
}
