package ru.yandex.direct.hourglass.implementations.updateschedule;

import java.util.function.Supplier;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.hourglass.updateschedule.MainScheduleVersionExtractor;

public class MainScheduleVersionExtractorImpl implements MainScheduleVersionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MainScheduleVersionExtractorImpl.class);
    private final Supplier<String> mainVersionExtractor;

    private static final Pattern END_OF_LINE_PATTERN = Pattern.compile("\r\n|\r|\n");

    public MainScheduleVersionExtractorImpl(Supplier<String> mainVersionExtractor) {
        this.mainVersionExtractor = mainVersionExtractor;
    }

    @Override
    public String getVersion() {
        return formatVersion(mainVersionExtractor.get());
    }

    private String formatVersion(String srcString) {
        String[] lines = END_OF_LINE_PATTERN.split(srcString);
        if (lines.length > 1) {
            logger.warn("version contains more than 1 line; using first line as version");
        }
        return lines[0];
    }
}
