package ru.yandex.direct.hourglass.implementations.updateschedule;

import java.time.Instant;
import java.util.Objects;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.client.SchedulerInstance;

public class SchedulerInstanceImpl implements SchedulerInstance {
    private final InstanceId instanceId;
    private final String version;
    private final boolean isMain;
    private final String instanceMeta;
    private final Instant heartbeatTime;
    private final boolean isActive;


    public SchedulerInstanceImpl(InstanceId instanceId, String version, boolean isMain,
                                 Instant heartbeatTime, String instanceMeta, boolean isActive) {
        this.instanceId = instanceId;
        this.version = version;
        this.isMain = isMain;
        this.instanceMeta = instanceMeta;
        this.heartbeatTime = heartbeatTime;
        this.isActive = isActive;
    }

    public InstanceId getInstanceId() {
        return instanceId;
    }

    public String getVersion() {
        return version;
    }


    public String getInstanceMeta() {
        return instanceMeta;
    }

    public Instant getHeartbeatTime() {
        return heartbeatTime;
    }

    @Override
    public boolean isActive() {
        return isActive;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchedulerInstanceImpl that = (SchedulerInstanceImpl) o;
        return isMain == that.isMain &&
                isActive() == that.isActive() &&
                Objects.equals(getInstanceId(), that.getInstanceId()) &&
                Objects.equals(getVersion(), that.getVersion()) &&
                Objects.equals(getInstanceMeta(), that.getInstanceMeta()) &&
                Objects.equals(getHeartbeatTime(), that.getHeartbeatTime());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getInstanceId(), getVersion(), isMain, getInstanceMeta(), getHeartbeatTime(), isActive());
    }

    @Override
    public String toString() {
        return "SchedulerInstanceImpl{" +
                "instanceId=" + instanceId +
                ", version='" + version + '\'' +
                ", isMain=" + isMain +
                ", instanceMeta='" + instanceMeta + '\'' +
                ", heartbeatTime=" + heartbeatTime +
                ", isActive=" + isActive +
                '}';
    }
}
