package ru.yandex.direct.hourglass.storage;

import java.util.Set;

public enum JobStatus {
    STOPPED {
        @Override
        public Set<JobStatus> getAllowedTransitionsList() {
            return Set.of(READY);
        }
    },
    LOCKED {
        @Override
        public Set<JobStatus> getAllowedTransitionsList() {
            return Set.of(STOPPED, EXPIRED, READY, LOCKED, ARCHIVED);
        }
    },
    READY {
        @Override
        public Set<JobStatus> getAllowedTransitionsList() {
            return Set.of(LOCKED, STOPPED, ARCHIVED);
        }
    },
    EXPIRED {
        @Override
        public Set<JobStatus> getAllowedTransitionsList() {
            return Set.of(READY, ARCHIVED);
        }
    },
    ARCHIVED {
        @Override
        public Set<JobStatus> getAllowedTransitionsList() {
            return Set.of();
        }
    };

    private volatile Set<JobStatus> allowedTransitions = null;

    abstract Set<JobStatus> getAllowedTransitionsList();

    public Set<JobStatus> getAllowedTransitions() {
        if (allowedTransitions == null) {
            allowedTransitions = getAllowedTransitionsList();
        }

        return allowedTransitions;
    }
}
