package ru.yandex.direct.hourglass.storage;

import java.time.Instant;
import java.util.Collection;

import ru.yandex.direct.hourglass.TaskProcessingResult;

public interface Update {
    Update wherePrimaryIdIn(Collection<PrimaryId> primaryIds);

    Update whereJobStatus(JobStatus jobStatus);

    Update whereNextRunLeNow();

    Update whereTaskId(TaskId taskId);

    Update setNextRun(Instant nextRun);

    Update setJobStatus(JobStatus jobStatus);

    Update pingJob();

    Update setTaskProcessingResult(TaskProcessingResult taskProcessingResult);

    Update setTaskId(TaskId taskId);

    int execute();

    Update setNeedReschedule(boolean b);

    Update whereNeedReschedule(boolean b);
}
