package ru.yandex.direct.hourglass.storage.implementations;

import java.time.Instant;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.hourglass.storage.Job;
import ru.yandex.direct.hourglass.storage.JobStatus;
import ru.yandex.direct.hourglass.storage.PrimaryId;
import ru.yandex.direct.hourglass.storage.TaskId;

public class JobImpl implements Job {
    private final PrimaryId primaryId;
    private final TaskId taskId;
    private final String scheduleHash;
    private final TaskProcessingResult taskProcessingResult;
    private final Instant nextRun;
    private final JobStatus jobStatus;
    private final boolean needReschedule;
    private final InstanceId instanceId;
    private final String meta;

    public JobImpl(PrimaryId primaryId, TaskId taskId, String scheduleHash,
                   TaskProcessingResult taskProcessingResult, Instant nextRun,
                   JobStatus jobStatus, boolean needReschedule, InstanceId instanceId, String meta) {
        this.primaryId = primaryId;
        this.taskId = taskId;
        this.scheduleHash = scheduleHash;
        this.taskProcessingResult = taskProcessingResult;
        this.nextRun = nextRun;
        this.jobStatus = jobStatus;
        this.needReschedule = needReschedule;
        this.instanceId = instanceId;
        this.meta = meta;
    }

    @Override
    public PrimaryId primaryId() {
        return primaryId;
    }

    @Override
    public TaskId taskId() {
        return taskId;
    }

    @Override
    public String getScheduleHash() {
        return scheduleHash;
    }

    @Override
    public TaskProcessingResult taskProcessingResult() {
        return taskProcessingResult;
    }

    @Override
    public Instant nextRun() {
        return nextRun;
    }

    @Override
    public JobStatus jobStatus() {
        return jobStatus;
    }

    @Override
    public InstanceId instanceId() {
        return instanceId;
    }

    @Override
    public boolean needReschedule() {
        return needReschedule;
    }

    @Override
    public String meta() {
        return meta;
    }

    @Override
    public String toString() {
        return "JobImpl{" +
                "primaryId=" + primaryId +
                ", taskId=" + taskId +
                ", taskProcessingResult=" + taskProcessingResult +
                ", nextRun=" + nextRun +
                ", jobStatus=" + jobStatus +
                ", needReschedule=" + needReschedule +
                ", instanceId=" + instanceId +
                ", meta='" + meta + '\'' +
                '}';
    }
}
