package ru.yandex.direct.hourglass.storage.implementations;

import java.util.Objects;

import ru.yandex.direct.hourglass.storage.TaskId;

public class TaskIdImpl implements TaskId {
    private final String name;
    private final String params;

    public TaskIdImpl(String name, String params) {
        this.name = name;
        this.params = params;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String param() {
        return params;
    }

    @Override
    public String toString() {
        return "TaskIdImpl{" +
                "name='" + name + '\'' +
                ", params='" + params + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskIdImpl taskId = (TaskIdImpl) o;
        return Objects.equals(name, taskId.name) &&
                Objects.equals(params, taskId.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, params);
    }
}
