package ru.yandex.direct.hourglass.storage.implementations.memory;

import ru.yandex.direct.hourglass.storage.PrimaryId;

public class IntegerPrimaryId implements PrimaryId {
    private final long id;

    public IntegerPrimaryId(long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return Long.toString(id);
    }

    public long getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IntegerPrimaryId primaryId = (IntegerPrimaryId) o;
        return getId() == primaryId.getId();
    }

    @Override
    public int hashCode() {
        return Long.hashCode(getId());
    }
}
