package ru.yandex.direct.hourglass.storage.implementations.memory;

import java.time.Instant;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.hourglass.storage.Job;
import ru.yandex.direct.hourglass.storage.JobStatus;
import ru.yandex.direct.hourglass.storage.PrimaryId;
import ru.yandex.direct.hourglass.storage.TaskId;

public class MutableJob implements Job {
    private PrimaryId primaryId;
    private TaskId taskId;
    private String scheduleHash;
    private TaskProcessingResult taskProcessingResult;
    private Instant nextRun;
    private JobStatus jobStatus;
    private boolean needReschedule;
    private String meta;

    public MutableJob() {

    }

    public MutableJob(Job job) {
        this.primaryId = job.primaryId();
        this.taskId = job.taskId();
        this.scheduleHash = job.getScheduleHash();
        this.taskProcessingResult = job.taskProcessingResult();
        this.nextRun = job.nextRun();
        this.jobStatus = job.jobStatus();
        this.needReschedule = job.needReschedule();
    }

    @Override
    public PrimaryId primaryId() {
        return primaryId;
    }

    @Override
    public TaskId taskId() {
        return taskId;
    }

    @Override
    public String getScheduleHash() {
        return scheduleHash;
    }

    @Override
    public TaskProcessingResult taskProcessingResult() {
        return taskProcessingResult;
    }

    @Override
    public Instant nextRun() {
        return nextRun;
    }

    @Override
    public JobStatus jobStatus() {
        return jobStatus;
    }

    @Override
    public InstanceId instanceId() {
        return null;
    }

    @Override
    public boolean needReschedule() {
        return needReschedule;
    }

    @Override
    public String meta() {
        return meta;
    }

    public MutableJob setTaskId(TaskId taskId) {
        this.taskId = taskId;
        return this;
    }

    public MutableJob setPrimaryId(PrimaryId primaryId) {
        this.primaryId = primaryId;
        return this;
    }

    public MutableJob setScheduleHash(String scheduleHash) {
        this.scheduleHash = scheduleHash;
        return this;
    }

    public MutableJob setTaskProcessingResult(TaskProcessingResult taskProcessingResult) {
        this.taskProcessingResult = taskProcessingResult;
        return this;
    }

    public MutableJob setNextRun(Instant nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    public MutableJob setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    public MutableJob setNeedReschedule(boolean needReschedule) {
        this.needReschedule = needReschedule;
        return this;
    }

    public MutableJob setMeta(String meta) {
        this.meta = meta;
        return this;
    }
}
