package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Branch {
    private String name;
    private String ref;

    @JsonCreator
    public Branch(
            @JsonProperty("name") String name,
            @JsonProperty("ref") @JsonInclude(JsonInclude.Include.NON_ABSENT) String ref
    ) {
        this.name = name;
        this.ref = ref;
    }

    public String getName() {
        return name;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getRef() {
        return ref;
    }
}
