package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
class ExportInfo {
    private ExportInfoRequest request;
    private String name;
    private String branch;

    @JsonCreator
    ExportInfo(
            @JsonProperty("request") ExportInfoRequest request,
            @JsonProperty("name") String name,
            @JsonProperty("branch") String branch
    ) {
        this.request = request;
        this.name = name;
        this.branch = branch;
    }

    @JsonProperty("request")
    public ExportInfoRequest getRequest() {
        return request;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("branch")
    public String getBranch() {
        return branch;
    }
}
