package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ExportInfoRequest {
    private CustomBoolean allForms;
    private String format;
    private String project;
    private String branch;
    private String keyset;
    private CustomBoolean flatKeyset;
    private String language;

    @JsonCreator
    public ExportInfoRequest(
            @JsonProperty("all-forms") CustomBoolean allForms,
            @JsonProperty("format") String format,
            @JsonProperty("project-id") String project,
            @JsonProperty("branch-id") String branch,
            @JsonProperty("keyset-id") String keyset,
            @JsonProperty("flat-keyset") CustomBoolean flatKeyset,
            @JsonProperty("language") String language
    ) {
        this.allForms = allForms;
        this.format = format;
        this.project = project;
        this.branch = branch;
        this.keyset = keyset;
        this.flatKeyset = flatKeyset;
        this.language = language;
    }

    @JsonProperty("all-forms")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CustomBoolean getAllForms() {
        return allForms;
    }

    @JsonProperty("format")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getFormat() {
        return format;
    }

    @JsonProperty("project-id")
    public String getProject() {
        return project;
    }

    @JsonProperty("branch-id")
    public String getBranch() {
        return branch;
    }

    @JsonProperty("keyset-id")
    public String getKeyset() {
        return keyset;
    }

    @JsonProperty("flat-keyset")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CustomBoolean getFlatKeyset() {
        return flatKeyset;
    }

    @JsonProperty("language")
    public String getLanguage() {
        return language;
    }
}
