package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Стандартный жизненный цикл ключа:
 * <p>
 * 1. Новый ключ пришел от разработчиков в статусе REQUIRES_TRANSLATION
 * 2. Пришел переводчик, написал для ключа переводы, перевел в статус TRANSLATED
 * 3. Пришел менеджер, прочитал переводы, перевел в APPROVED.
 */
public enum KeyTranslationStatus {
    @JsonProperty("requires_translation")
    REQUIRES_TRANSLATION,
    @JsonProperty("translated")
    TRANSLATED,
    @JsonProperty("approved")
    APPROVED;
}
