package ru.yandex.direct.i18n.tanker;

import java.io.IOException;
import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.direct.i18n.Language;

/*
Не осилил значения по умолчанию в property-based JsonCreator, поэтому - вот.
 */
public class KeysetJsonParser {
    private KeysetJsonParser() {
    }

    enum Field {
        NAME("name"),
        PROJECT("project"),
        ORIGINAL_LANGUAGE("original_language"),
        LANGUAGES("languages"),
        JSON_CHECKS("json_checks"),
        AUTO_APPROVE_ORIGINAL("auto_approve_original"),
        AUTO_APPROVE("auto_approve"),
        AUTO_LOCKED("auto_locked"),
        CONTEXT("context");

        private String name;

        Field(String name) {
            this.name = name;
        }

        String getName() {
            return name;
        }

        boolean getDefaultBoolean(JsonNode tree) {
            return tree.has(name) && tree.get(name).asBoolean();
        }
    }

    public static Keyset parse(JsonNode tree) throws IOException {

        ObjectMapper mapper = new ObjectMapper();
        return new Keyset(
                tree.get(Field.NAME.getName()).asText(),
                tree.get(Field.PROJECT.getName()).asText(),
                mapper.readerFor(Language.class).readValue(tree.get(Field.ORIGINAL_LANGUAGE.getName())),
                mapper.readerFor(new TypeReference<Set<Language>>() {
                }).readValue(tree.get(Field.LANGUAGES.getName())),
                Field.JSON_CHECKS.getDefaultBoolean(tree),
                Field.AUTO_APPROVE_ORIGINAL.getDefaultBoolean(tree),
                Field.AUTO_APPROVE.getDefaultBoolean(tree),
                Field.AUTO_LOCKED.getDefaultBoolean(tree)
        );
    }
}
