package ru.yandex.direct.i18n.tanker;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.i18n.Language;

@JsonIgnoreProperties(ignoreUnknown = true)
class KeysetTranslationsMeta {
    private EnumSet<Language> languages;

    @JsonCreator
    KeysetTranslationsMeta(@JsonProperty("languages") Set<Language> languages) {
        this.languages = EnumSet.copyOf(languages);
    }

    @JsonProperty("languages")
    public Set<Language> getLanguages() {
        return Collections.unmodifiableSet(languages);
    }
}
