package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TankerError {
    private String message;
    private String code;

    @JsonCreator
    public TankerError(
            @JsonProperty("message") String message,
            @JsonProperty("code") @JsonInclude(JsonInclude.Include.NON_ABSENT) String code
    ) {
        this.message = message;
        this.code = code;
    }

    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    @Override
    public String toString() {
        return "TankerError{" +
                "message='" + message + '\'' +
                ", code='" + code + '\'' +
                '}';
    }
}
