package ru.yandex.direct.i18n.tanker;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TankerList<T> {
    private String project;
    private String kind;
    private List<T> items;

    @JsonCreator
    public TankerList(
            @JsonProperty("project") String project,
            @JsonProperty("kind") String kind,
            @JsonProperty("items") List<T> items
    ) {
        this.project = project;
        this.kind = kind;
        this.items = items;
    }

    @JsonProperty("project")
    public String getProject() {
        return project;
    }

    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    @JsonProperty("items")
    public List<T> getItems() {
        return Collections.unmodifiableList(items);
    }
}
