package ru.yandex.direct.i18n.tanker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TankerResponse<T> {
    private T data;
    private TankerError error;

    /**
     * Танкер странный, он умеет сообщать об ошибке тремя разными способами:
     * <p>
     * 1. Вернуть HTTP-status отличный от 200;
     * 2. Вернуть в ответе "error" вместо "data";
     * 3. Вернуть в "data" поле "message" с сообщением об ошибке.
     * <p>
     * (Есть и еще способы, специфичные для конкретных запросов.)
     * <p>
     * Первая ошибка обрабатывается раньше, в клиенте, вторую ловим тут,
     * третью не ловим - не осилил написать соответствующий JsonCreator,
     * из-за проблем с дженериками. Так что, третий вид ошибок будет
     * выглядеть как ошибка парсинга json.
     */
    @JsonCreator
    public TankerResponse(
            @JsonProperty("data") @JsonInclude(JsonInclude.Include.NON_ABSENT) T data,
            @JsonProperty("error") @JsonInclude(JsonInclude.Include.NON_ABSENT) TankerError error
    ) {
        this.data = data;
        this.error = error;
    }

    public T getData() {
        if (hasError()) {
            throw new IllegalStateException("Tanker returned error: " + error);
        } else {
            return data;
        }
    }

    public TankerError getError() {
        return error;
    }

    public boolean hasError() {
        return error != null;
    }

    @Override
    public String toString() {
        return "TankerResponse{" +
                "data=" + data +
                ", error=" + error +
                '}';
    }
}
