package ru.yandex.direct.i18n.tanker;

import java.util.Optional;
import java.util.Set;

import ru.yandex.direct.i18n.Language;

public class TankerWithBranch implements AutoCloseable {
    private Tanker tanker;
    private String branch;

    public TankerWithBranch(Tanker tanker, String branch) {
        this.tanker = tanker;
        this.branch = branch;
    }

    public String getProject() {
        return tanker.getProject();
    }

    public String getBranch() {
        return branch;
    }

    public void createKeyset(Keyset keyset) {
        tanker.createKeyset(branch, keyset);
    }

    public void updateKeyset(String keysetName, Keyset keyset) {
        tanker.updateKeyset(branch, keysetName, keyset);
    }

    public Optional<Keyset> getKeyset(String keysetName) {
        return tanker.getKeyset(branch, keysetName);
    }

    public TankerResponse<TankerList<Keyset>> listKeysets() {
        return tanker.listKeysets(branch);
    }

    public ProjectTranslations getKeysetTranslations(String keyset, Set<Language> languages) {
        return tanker.getKeysetTranslations(branch, keyset, languages);
    }

    @Override
    public void close() {
        if (tanker != null) {
            tanker.close();
        }
    }

    public void merge(ProjectTranslations translations, Set<Language> languages) {
        tanker.merge(branch, translations, languages);
    }
}
