package ru.yandex.direct.i18n.tanker.cli;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.i18n.tanker.Tanker;

public class CommonParams {
    @Parameter(
            names = {"-u", "--url"},
            description = "Tanker URL."
    )
    String url = Tanker.TANKER_URL;

    @Parameter(
            names = {"-p", "--project"},
            description = "Default value is taken from Direct config."
    )
    String project;

    @Parameter(
            names = {"-t", "--token"},
            description = "Tanker token value."
    )
    String token;

    @Parameter(
            names = {"-f", "--token-file"},
            description = "Default value is taken from Direct config."
    )
    String tokenFile;

    @Parameter(
            names = {"--debug"},
            description = "Write all requests to stderr."
    )
    boolean debug = false;

    @Parameter(
            names = {"-b", "--branch"},
            description = "Tanker branch to use."
    )
    String branch = "master";

    @Parameter(
            names = {"-r", "--package-prefix"},
            description =
                    "Package prefix to scan for TranslationBundle subclasses."
                            + " Note that only classes within classpath will be scanned."
    )
    String packagePrefix;

    public CommonParams withProject(String project) {
        this.project = project;
        return this;
    }

    public CommonParams withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return this;
    }

    public CommonParams withPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
        return this;
    }
}
