package ru.yandex.direct.i18n.tanker.cli;

import java.util.Collections;
import java.util.Set;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

import ru.yandex.direct.i18n.tanker.KeyTranslationStatus;
import ru.yandex.direct.jcommander.Command;

@Parameters(
        commandDescription = "By default, download only approved complete translations."
)
@SuppressWarnings("checkstyle:visibilitymodifier")
public class DownloadCommand extends Command {
    @Parameter(
            names = {"-s", "--status"},
            description =
                    "Download translations with specified status. "
                            + "This option can be specified multiple times with different statuses. "
                            + "Use 'status-list' command to see list of available statuses."
    )
    public Set<KeyTranslationStatus> statusSet = Collections.singleton(KeyTranslationStatus.APPROVED);

    @Parameter(
            names = {"-i", "--incomplete"},
            description = "Download incomplete translations as well. "
    )
    public boolean incomplete = false;

    @Parameter(
            names = {"-d", "--target-dir"},
            description = "Directory name, where downloaded translations will be stored"
    )
    public String targetDir;

    @Parameter(
            names = {"--single-keyset"},
            description = "Download single custom keyset. " +
                    "Location is speified using target-dir and single-filename-prefix parameters"
    )
    public String singleKeyset;

    @Parameter(
            names = {"--single-filename-prefix"},
            description = "Filename prefix to use with single-keyset parameter. " +
                    "Created files will have names PREFIX.LANG.json"
    )
    public String singleFilename;

    public DownloadCommand() {
        super("download");
    }

    public DownloadCommand withTargetDir(String targetDir) {
        this.targetDir = targetDir;
        return this;
    }
}
