package ru.yandex.direct.i18n.tanker.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;

import ru.yandex.direct.i18n.tanker.KeyTranslationStatus;
import ru.yandex.direct.jcommander.Command;

@Parameters(
        commandDescription =
                "Find compatible translations in specified TJSON file and copy them to our project."
)
@SuppressWarnings("checkstyle:visibilitymodifier")
public class MigrateCommand extends Command {
    @Parameter(
            names = {"-n", "--status"},
            description = "Set this status (see 'status_list' command) on completely migrated keys."
    )
    public KeyTranslationStatus completeMigrationStatus = KeyTranslationStatus.TRANSLATED;

    @Parameter(
            required = true,
            description = "<ours.tjson> <theirs.tjson>"
    )
    List<String> oursTheirs = new ArrayList<>();

    public MigrateCommand() {
        super("migrate");
    }

    public Path getOurs() {
        return Paths.get(oursTheirs.get(0));
    }

    public Path getTheirs() {
        return Paths.get(oursTheirs.get(1));
    }

    @Override
    public void validate() {
        super.validate();
        if (oursTheirs.size() != 2) {
            throw new ParameterException("Expected two positional arguments, got: " + oursTheirs.size());
        }
    }
}
