package ru.yandex.direct.i18n.tanker.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;

import ru.yandex.direct.jcommander.Command;

@Parameters(
        commandDescription =
                "Useful to make diff between original and migrated TJSON files, for example: " +
                        "diff -u <(tanker-tool reformat ours.tjson) <(tanker-tool migrate ours.tjson theirs.tjson)"
)
public class ReformatCommand extends Command {
    @Parameter(
            required = true,
            description = "<tanker-export.tjson>"
    )
    List<String> tankerExports = new ArrayList<>();

    public ReformatCommand() {
        super("reformat");
    }

    public Path getTankerExportPath() {
        return Paths.get(tankerExports.get(0));
    }

    @Override
    public void validate() {
        super.validate();
        if (tankerExports.size() != 1) {
            throw new ParameterException("Expected one positional argument, got: " + tankerExports.size());
        }
    }
}
