package ru.yandex.direct.i18n.tanker.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ChainAdapter implements Adapter {
    private Adapter[] adapters;

    public ChainAdapter(Adapter... adapters) {
        this.adapters = adapters;
    }

    @Override
    public List<LanguageEntry> adapt(MigrationSource source, LanguageEntry form) {
        return Arrays.stream(adapters)
                .map(matcher -> matcher.adapt(source, form))
                .filter(forms -> !forms.isEmpty())
                .findFirst()
                .orElse(Collections.emptyList());
    }
}
