package ru.yandex.direct.i18n.tanker.migration;

import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.dict.DictionaryEntry;
import ru.yandex.direct.i18n.tanker.Translation;

public class LanguageEntry {
    private Language language;
    private DictionaryEntry entry;

    public LanguageEntry(Language language, DictionaryEntry entry) {
        this.language = language;
        this.entry = entry;
    }

    public static LanguageEntry forTranslation(Translation translation) {
        return new LanguageEntry(
                translation.getLanguage(),
                translation.asDictionaryEntry()
        );
    }

    public Language getLanguage() {
        return language;
    }

    public DictionaryEntry getEntry() {
        return entry;
    }

    @Override
    public String toString() {
        return "LanguageEntry{" +
                "language=" + language +
                ", entry='" + entry + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LanguageEntry that = (LanguageEntry) o;

        if (language != that.language) {
            return false;
        }
        return entry.equals(that.entry);

    }

    @Override
    public int hashCode() {
        int result = language.hashCode();
        result = 31 * result + entry.hashCode();
        return result;
    }
}
