package ru.yandex.direct.i18n.tanker.migration;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.tanker.KeyTranslationStatus;
import ru.yandex.direct.i18n.tanker.KeyTranslations;
import ru.yandex.direct.i18n.tanker.KeysetTranslations;
import ru.yandex.direct.i18n.tanker.ProjectTranslations;
import ru.yandex.direct.i18n.tanker.Translation;

public class Migration {
    private MigrationSource source;
    private Adapter adapter;

    public Migration(MigrationSource source, Adapter adapter) {
        this.source = source;
        this.adapter = adapter;
    }

    public Migration(MigrationSource source) {
        this(source, makeDefaultAdapter());
    }

    public static Adapter makeDefaultAdapter() {
        return new ChainAdapter(
                new StraightAdapter(),
                new OursSuffixAdapter(Pattern.compile(":\\s*\\{\\w*\\}$")),
                new OursSuffixAdapter(Pattern.compile(":\\s*\\{\\w*\\}\\s*=\\s*\\{\\w*\\}$")),
                new WordReplaceAdapter("JSON/XML", "JSON")
        );
    }

    public void migrate(ProjectTranslations ours, KeyTranslationStatus completeMigrationStatus) {
        for (KeysetTranslations ourKeyset : ours.getKeysets().values()) {
            for (KeyTranslations ourKeyTranslations : ourKeyset.getKeyTranslationsMap().values()) {
                Map<Language, Boolean> alreadyComplete = ourKeyTranslations.getTranslations().stream()
                        .collect(Collectors.toMap(
                                Translation::getLanguage,
                                Translation::isComplete
                        ));

                for (Translation translation : ourKeyTranslations.getTranslations()) {
                    adapter.adapt(source, LanguageEntry.forTranslation(translation)).forEach(
                            newEntry -> ourKeyTranslations
                                    .getTranslation(newEntry.getLanguage())
                                    .ifPresent(old -> old.mergeDictionaryEntry(newEntry.getEntry()))
                    );
                }

                ourKeyTranslations.getTranslations().forEach(translation -> {
                    if (!alreadyComplete.get(translation.getLanguage()) && translation.isComplete()) {
                        translation.setStatus(completeMigrationStatus);
                    }
                });
            }
        }
    }
}
