package ru.yandex.direct.i18n.tanker.migration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.tanker.KeyTranslations;
import ru.yandex.direct.i18n.tanker.KeysetTranslations;
import ru.yandex.direct.i18n.tanker.ProjectTranslations;

public class MigrationSource {
    private Map<LanguageEntry, List<LanguageEntry>> translationMap;

    public MigrationSource(ProjectTranslations translations) {
        this.translationMap = new HashMap<>();

        for (KeysetTranslations keysetTranslations : translations.getKeysets().values()) {
            for (KeyTranslations keyTranslations : keysetTranslations.getKeyTranslationsMap().values()) {
                List<LanguageEntry> entries = keyTranslations.getTranslations().stream()
                        .map(translation -> new LanguageEntry(
                                translation.getLanguage(),
                                translation.asDictionaryEntry()
                        ))
                        .filter(translation -> translation.getEntry().isComplete())
                        .collect(Collectors.toList());

                // Если есть перевод только для одного языка, то в миграции он не поможет
                if (entries.size() > 1) {
                    for (LanguageEntry entry : entries) {
                        translationMap.put(entry, entries);
                    }
                }
            }
        }
    }

    public List<LanguageEntry> get(LanguageEntry form) {
        return translationMap.containsKey(form) ? translationMap.get(form) : Collections.emptyList();
    }

    public boolean isEmpty() {
        return translationMap.isEmpty();
    }
}
