package ru.yandex.direct.i18n.tanker.migration;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.dict.DictionaryEntry;
import ru.yandex.direct.i18n.dict.SingularEntry;

public class OursSuffixAdapter implements Adapter {
    private Pattern suffixPattern;

    public OursSuffixAdapter(Pattern suffixPattern) {
        this.suffixPattern = suffixPattern;
    }

    @Override
    public List<LanguageEntry> adapt(MigrationSource source, LanguageEntry languageEntry) {
        DictionaryEntry entry = languageEntry.getEntry();

        if (!(entry instanceof SingularEntry)) {
            // Поддержка множественных форм не была сделана сразу, потому что это не актуально
            // для миграции из проекта direct - там нет множественных форм.
            return Collections.emptyList();
        } else {
            String form = ((SingularEntry) entry).getForm();
            Matcher suffixMatcher = suffixPattern.matcher(form);

            if (!suffixMatcher.find()) {
                return Collections.emptyList();
            } else {
                if (suffixMatcher.end() != form.length()) {
                    throw new IllegalArgumentException("suffixPattern must match at the end of the string.");
                }

                String suffix = suffixMatcher.group();

                return source.get(new LanguageEntry(
                        languageEntry.getLanguage(),
                        new SingularEntry(form.substring(0, form.length() - suffix.length()))
                ))
                        .stream()
                        .map(le -> new LanguageEntry(
                                le.getLanguage(),
                                new SingularEntry(((SingularEntry) le.getEntry()).getForm() + suffix)
                        ))
                        .collect(Collectors.toList());
            }
        }
    }
}
