package ru.yandex.direct.i18n.tanker.migration;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.dict.DictionaryEntry;
import ru.yandex.direct.i18n.dict.SingularEntry;

public class WordReplaceAdapter implements Adapter {
    private String ours;
    private String theirs;

    public WordReplaceAdapter(String ours, String theirs) {
        this.ours = ours;
        this.theirs = theirs;
    }

    @Override
    public List<LanguageEntry> adapt(MigrationSource source, LanguageEntry languageEntry) {
        DictionaryEntry entry = languageEntry.getEntry();

        if (!(entry instanceof SingularEntry)) {
            // Поддержка множественных форм не была сделана сразу, потому что это не актуально
            // для миграции из проекта direct - там нет множественных форм.
            return Collections.emptyList();
        } else {
            String form = ((SingularEntry) entry).getForm();
            Pattern oursWordPattern = Pattern.compile("\\b" + Pattern.quote(ours) + "\\b");
            Pattern theirsWordPattern = Pattern.compile("\\b" + Pattern.quote(theirs) + "\\b");

            if (!oursWordPattern.matcher(form).find()) {
                return Collections.emptyList();
            } else {
                return source.get(
                        new LanguageEntry(
                                languageEntry.getLanguage(),
                                new SingularEntry(oursWordPattern.matcher(form).replaceAll(theirs))
                        )
                )
                        .stream()
                        .filter(newEntry -> theirsWordPattern.matcher(
                                ((SingularEntry) newEntry.getEntry()).getForm()).find()
                        )
                        .map(newEntry -> new LanguageEntry(
                                newEntry.getLanguage(),
                                new SingularEntry(
                                        theirsWordPattern
                                                .matcher(((SingularEntry) newEntry.getEntry()).getForm())
                                                .replaceAll(ours)
                                )
                        ))
                        .collect(Collectors.toList());
            }
        }
    }
}
