package ru.yandex.direct.i18n;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Все языки используемые в Директе.
 */
public enum Language {
    EN("en", 2),
    TR("tr", 2),
    RU("ru", 3),
    UK("uk", 3);

    private final String langString;
    private final int numberOfPluralForms;

    /**
     * @param langString - строка с коротким названием языка, значения те же, что в Locale.
     */
    Language(String langString, int numberOfPluralForms) {
        this.langString = langString;
        this.numberOfPluralForms = numberOfPluralForms;
    }

    @JsonCreator
    public static Language fromLangString(String langString) {
        switch (langString) {
            case "en":
                return EN;
            case "tr":
                return TR;
            case "ru":
                return RU;
            case "uk":
                return UK;
            default:
                throw new I18NException("Bad langString: " + langString);
        }
    }

    public static Language fromLocale(Locale locale) {
        return fromLangString(locale.getLanguage());
    }

    public static Set<Language> getValueSet() {
        return EnumSet.allOf(Language.class);
    }

    @JsonValue
    public String getLangString() {
        return langString;
    }

    // Здесь умышленно нет метода getLocale(), потому что конвертация из языка в локаль - неоднозначна.

    public int getNumberOfPluralForms() {
        return numberOfPluralForms;
    }
}
