package ru.yandex.direct.i18n;

import java.util.Locale;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class MappingTranslatorFactory implements TranslatorFactory {
    private final Map<Locale, Translator> translators;

    MappingTranslatorFactory() {
        translators = ImmutableMap.of();
    }

    MappingTranslatorFactory(Map<Locale, Translator> translators) {
        this.translators = ImmutableMap.copyOf(translators);
    }

    MappingTranslatorFactory with(Translator translator) {
        Map<Locale, Translator> expandedTranslators = ImmutableMap.<Locale, Translator>builder()
                .putAll(translators)
                .put(translator.getLocale(), translator)
                .build();
        return new MappingTranslatorFactory(expandedTranslators);
    }

    @Override
    public Translator getTranslator(Locale locale) {
        if (translators.containsKey(locale)) {
            return translators.get(locale);
        } else {
            return translators.get(I18NBundle.EN);
        }
    }
}
