package ru.yandex.direct.i18n;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StrUtil {
    private StrUtil() {
    }

    /**
     * Аналогично {@link String#split(String, int)}, но:
     * - разбиение идет с конца строки
     * - разделителем выступает char, а не {@link String}
     *
     * @param s         разбиваемая строка
     * @param separator разделитель
     * @param limit     ограничение на число элементов
     * @return
     */
    public static String[] rsplit(String s, char separator, int limit) {
        String reversed = StringUtils.reverseDelimited(s, separator);
        String[] tokens = StringUtils.split(reversed, separator);
        String[] result = trimToSize(tokens, separator, limit);
        ArrayUtils.reverse(result);
        return result;
    }

    /**
     * Возвращает массив(или его копию) с не более чем {@code limit} элементами.
     * Если в исходном массиве более чем {@code limit} элементов, то последний элемент массива состоит из лишних элементов,
     * склееных сепаратором @{code separator}
     *
     * @param tokens    исходный массив
     * @param separator сепаратор, используемый при 'склеивании' лишних элементов
     * @param limit     ограничение на число элементов массива
     * @return
     */
    private static String[] trimToSize(String[] tokens, char separator, int limit) {
        if (tokens.length > limit) {
            String[] tmp = ArrayUtils.subarray(tokens, 0, limit);
            tmp[tmp.length - 1] = StringUtils.join(ArrayUtils.subarray(tokens, limit - 1, tokens.length), separator);
            return tmp;
        } else {
            return tokens;
        }
    }
}
