package ru.yandex.direct.i18n;

import java.util.Locale;

/**
 * TranslationFactory - это сущность, которая знает где взять переводы
 * и как создать из них Translator для конкретной локали.
 * <p>
 * Т.е. при инициализации приложения у нас есть TranslationFactory,
 * а для обработки пользовательского запроса, мы, зная его локаль, получаем
 * из фабрики конкретный Translator, возможно, помещая его в thread-local
 * на все время сессии.
 */
public interface TranslatorFactory {
    Translator getTranslator(Locale locale);
}
