package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.direct.i18n.I18NException;

public abstract class AbstractMethodInterpreter implements MethodInterpreter {
    private final Map<Class<? extends Annotation>, AnnotationHandler> annotationMap;

    /**
     * Возвращает пустышку, от нее никакой пользы нет, пока хотя бы один раз
     * не будет вызван метод withAnnotationHandler(). Пример см. в I18NBundle.
     */
    public AbstractMethodInterpreter() {
        annotationMap = new HashMap<>();
    }

    public void addAnnotationHandler(AnnotationHandler annotationHandler) {
        AnnotationHandler oldHandler = annotationMap.putIfAbsent(
                annotationHandler.getAnnotationType(),
                annotationHandler
        );
        if (oldHandler != null) {
            throw new I18NException(
                    "Ambiguous handlers for "
                            + annotationHandler.getAnnotationType() + ": "
                            + oldHandler + " and " + annotationHandler
            );
        }
    }

    protected boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return annotationMap.containsKey(annotation);
    }

    protected AnnotationHandler handlerFor(Class<? extends Annotation> annotation) {
        return annotationMap.get(annotation);
    }
}
