package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import ru.yandex.direct.i18n.I18NException;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.TranslationRequest;
import ru.yandex.direct.i18n.dict.SingularEntry;
import ru.yandex.direct.i18n.types.MessageFormatTranslatable;
import ru.yandex.direct.i18n.types.StringTranslatable;

/**
 * Обработчик для @MessageFormatStub.
 */
public class MessageFormatHandler implements AnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return MessageFormatStub.class;
    }

    @Override
    public MethodInterpretation interpret(Method method) {
        for (Annotation[] methodAnnotations : method.getParameterAnnotations()) {
            for (Annotation annotation : methodAnnotations) {
                if (annotation.annotationType().equals(Plural.class)) {
                    throw new I18NException("@Plural without @PluralStub on method: " + method);
                }
            }
        }
        return unsafeInterpret(method);
    }

    @Override
    public MethodInterpretation unsafeInterpret(Method method) {
        StringTranslatable template = new StringTranslatable(TranslationKey.forMethod(method));
        String stub = method.getAnnotation(MessageFormatStub.class).value();

        return new MethodInterpretationWithStub() {
            @Override
            public String getStubTranslation(TranslationKey key) {
                return stub;
            }

            @Override
            public Translatable invoke(Object proxy, Object[] args) {
                return new MessageFormatTranslatable(template, args);
            }
        };
    }

    @Override
    public TranslationRequest getTranslationRequest(Method method) {
        MessageFormatStub stub = method.getAnnotation(MessageFormatStub.class);
        return new TranslationRequest(
                new SingularEntry(stub.value()),
                stub.language(),
                stub.comment()
        );
    }
}
