package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.i18n.Language;

/**
 * Аннотированный метод будет возвращать переведенную строку
 * и с помощью MessageFormat подставлять в нее переданные аргументы.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface MessageFormatStub {
    /**
     * Отладочный вариант перевода, представляющий собой шаблон для MessageFormat.
     * <p>
     * ВАЖНО! Это не настоящий перевод, он ни при каких условиях не используется
     * в MessageBundleTranslator. Им можно воспользоваться для тестирования кода
     * используя StubTranslator.
     */
    String value();

    /**
     * Комментарий для переводчиков Танкера.
     */
    String comment() default "";

    Language language() default Language.RU;
}
