package ru.yandex.direct.i18n.bundle;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;
import ru.yandex.direct.i18n.dict.PluralEntry3Form;
import ru.yandex.direct.i18n.types.MessageFormatTranslatable;
import ru.yandex.direct.i18n.types.PluralTranslatable;

public class MethodInterpretationWithPluralStub implements MethodInterpretation {
    private TranslationKey key;
    private Integer pluralParameterIndex;
    private PluralStub stub;

    public MethodInterpretationWithPluralStub(TranslationKey key, Integer pluralParameterIndex,
                                              PluralStub stub) {
        this.key = key;
        this.pluralParameterIndex = pluralParameterIndex;
        this.stub = stub;
    }

    public String getPluralStubTranslation(TranslationPluralKey key) {
        return Translator.pluralChoice(
                stub.language(),
                key.getNumeral(),
                new PluralEntry3Form(
                        stub.one(),
                        stub.some(),
                        stub.many()
                )
        );
    }

    @Override
    public Translatable invoke(Object proxy, Object[] args) {
        return new MessageFormatTranslatable(
                new PluralTranslatable(
                        new TranslationPluralKey(key, (Long) args[pluralParameterIndex])
                ),
                args
        );
    }

}
