package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import ru.yandex.direct.i18n.I18NException;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.TranslationRequest;
import ru.yandex.direct.i18n.dict.SingularEntry;
import ru.yandex.direct.i18n.types.StringTranslatable;

/**
 * Обработчик для @TranslationStub
 */
public class PlainStringHandler implements AnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return TranslationStub.class;
    }

    @Override
    public MethodInterpretation interpret(Method method) {
        if (method.getParameterCount() != 0) {
            throw new I18NException(
                    "Unexpected parameters in: " + method + ". "
                            + "TranslationStub doesn't allow any method parameters. "
                            + "If you need parametrized translation, consider using "
                            + "MessageFormatStub or PluralStub."
            );
        }
        return unsafeInterpret(method);
    }

    @Override
    public MethodInterpretation unsafeInterpret(Method method) {
        StringTranslatable translatable = new StringTranslatable(TranslationKey.forMethod(method));
        String stub = method.getAnnotation(TranslationStub.class).value();

        return new MethodInterpretationWithStub() {
            @Override
            public String getStubTranslation(TranslationKey key) {
                return stub;
            }

            @Override
            public Translatable invoke(Object proxy, Object[] args) {
                return translatable;
            }
        };
    }


    @Override
    public TranslationRequest getTranslationRequest(Method method) {
        TranslationStub stub = method.getAnnotation(TranslationStub.class);
        return new TranslationRequest(
                new SingularEntry(stub.value()),
                stub.language(),
                stub.comment()
        );
    }
}
