package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.i18n.Language;

/**
 * Аннотированный метод будет возвращать перевод, соответствующий определяющему
 * числительному, с подставленными в него аргументами с помощью MessageFormat.
 * и с помощью MessageFormat подставлять в нее переданные аргументы.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface PluralStub {
    /**
     * См. множественные ключи в https://doc.yandex-team.ru/Tanker/tech-dscr/concepts/tr_keys.xml#static-keys
     * <p>
     * ВАЖНО! Это не настоящий перевод, он ни при каких условиях не используется
     * в MessageBundleTranslator. Им можно воспользоваться для тестирования кода
     * используя StubTranslator.
     * <p>
     * На пальцах, что значат параметры в русском языке:
     * "1 яблоко" - это one
     * "2 яблока" - это some
     * "5 яблок"  - это many
     */
    String one();

    /**
     * См. one
     */
    String some();

    /**
     * См. one
     */
    String many();

    /**
     * Комментарий для переводчиков Танкера.
     */
    String comment() default "";

    Language language() default Language.RU;
}
