package ru.yandex.direct.i18n.bundle;

import java.util.Locale;

import ru.yandex.direct.i18n.Translator;

/**
 * Переводчик, полезный для целей тестирования.
 * Не требует настоящих переводов.
 * В качестве переводов использует строчки, указанные разработчиками в аннотациях
 */
public class StubTranslator implements Translator {
    private Locale locale;
    private MethodInterpreter methodInterpreter;

    public StubTranslator(Locale locale, MethodInterpreter methodInterpreter) {
        this.locale = locale;
        this.methodInterpreter = methodInterpreter;
    }

    @Override
    public String translateKey(String bundleName, String key) {
        return key;
    }

    @Override
    public String translateKey(TranslationKey key) {
        return ((MethodInterpretationWithStub) methodInterpreter.interpret(key.toMethod()))
                .getStubTranslation(key);
    }

    @Override
    public String translatePluralKey(TranslationPluralKey key) {
        return ((MethodInterpretationWithPluralStub) methodInterpreter.interpret(key.toMethod()))
                .getPluralStubTranslation(key);
    }

    @Override
    public Locale getLocale() {
        return locale;
    }
}
