package ru.yandex.direct.i18n.bundle;

import java.lang.reflect.Method;

public class TranslationKey {
    private Method method;

    private TranslationKey(Method method) {
        this.method = method;
    }

    static TranslationKey forMethod(Method method) {
        return new TranslationKey(method);
    }

    @Override
    public String toString() {
        return bundleName() + "." + keyName();
    }

    public String bundleName() {
        return method.getDeclaringClass().getCanonicalName();
    }

    public String keyName() {
        return method.getName();
    }

    public Method toMethod() {
        return method;
        /*
        Не уверен, насколько хорошо таскать с собой в ключе Method.
        Возможно стоит заменить его на имена класса и метода.

        try {
            return Class.forName(classCanonicalName).getDeclaredMethod(methodName);
        } catch (ClassNotFoundException exc) {
            throw new I18NException("Class not found: " + classCanonicalName);
        } catch (NoSuchMethodException exc) {
            throw new I18NException("Method not found: " + this);
        }
        */
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TranslationKey that = (TranslationKey) o;

        return method.equals(that.method);

    }

    @Override
    public int hashCode() {
        return method.hashCode();
    }
}
