package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.i18n.Language;

/**
 * Аннотированый метод будет возвращать перевод строки.
 * Аннотированый метод не может принимать никаких параметров.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface TranslationStub {
    /**
     * Отладочный вариант перевода.
     * <p>
     * ВАЖНО! Это не настоящий перевод, он ни при каких условиях не используется
     * в MessageBundleTranslator. Им можно воспользоваться для тестирования кода
     * используя StubTranslator.
     */
    String value();

    /**
     * Комментарий для переводчиков Танкера.
     */
    String comment() default "";

    Language language() default Language.RU;
}
