package ru.yandex.direct.i18n.bundle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import ru.yandex.direct.i18n.I18NException;

public class UnsafeMethodInterpreter extends AbstractMethodInterpreter {
    @Override
    public MethodInterpretation interpret(Method method) {
        if (method.isDefault()) {
            throw new I18NException("Default methods are not supported, see DIRECT-172039");
        } else {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (containsAnnotation(annotation.annotationType())) {
                    return handlerFor(annotation.annotationType()).unsafeInterpret(method);
                }
            }
            throw new I18NException("Not found handler for method: " + method);
        }
    }

    /**
     * @param annotationHandler Добавляемый обработчик аннотации
     * @return this с добавленным обработчиком
     */
    public UnsafeMethodInterpreter withAnnotationHandler(AnnotationHandler annotationHandler) {
        addAnnotationHandler(annotationHandler);
        return this;
    }
}
