package ru.yandex.direct.i18n.dict;

import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;

import ru.yandex.direct.i18n.Language;

public class BundleDictionaries<E extends DictionaryEntry> {
    private final ImmutableListMultimap<Language, BundleDictionary<E>> dictionaryMap;

    public BundleDictionaries(Collection<BundleDictionary<E>> bundleDictionaries) {
        dictionaryMap = Multimaps.index(bundleDictionaries, BundleDictionary::getLanguage);
    }

    public LocaleDictionaries<E> getFor(Locale locale) {
        return new LocaleDictionaries<>(
                locale,
                dictionaryMap
                        .get(Language.fromLocale(locale))
                        .stream()
                        .collect(Collectors.toMap(
                                BundleDictionary::getBundleName,
                                BundleDictionary::getDictionary
                        ))
        );
    }
}
