package ru.yandex.direct.i18n.dict;

import ru.yandex.direct.i18n.Language;

public class BundleDictionary<E extends DictionaryEntry> {
    private final String bundleName;
    private final Language language;
    private final Dictionary<E> dictionary;

    public BundleDictionary(String bundleName, Language language, Dictionary<E> dictionary) {
        this.bundleName = bundleName;
        this.language = language;
        this.dictionary = dictionary;
    }

    public String getBundleName() {
        return bundleName;
    }

    public Dictionary<E> getDictionary() {
        return dictionary;
    }

    public Language getLanguage() {
        return language;
    }

    @Override
    public String toString() {
        return BundleDictionary.class.getSimpleName() + "[" + bundleName + "/" + language + "]";
    }
}
