package ru.yandex.direct.i18n.dict;

import java.util.Locale;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class LocaleDictionaries<E extends DictionaryEntry> {
    private final Locale locale;
    private final ImmutableMap<String, Dictionary<E>> dictionaryMap;

    public LocaleDictionaries(Locale locale, Map<String, Dictionary<E>> dictionaryMap) {
        this.locale = locale;
        this.dictionaryMap = ImmutableMap.copyOf(dictionaryMap);
    }

    public Locale getLocale() {
        return locale;
    }

    public Map<String, Dictionary<E>> getDictionaries() {
        return dictionaryMap;
    }
}
