package ru.yandex.direct.i18n.dict;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.direct.i18n.I18NException;

public class PluralEntry2Form implements Entry2Form, PluralEntry {
    private String one;
    private String many;
    private String zero;

    public PluralEntry2Form(String one, String many, String zero) {
        if (one == null || many == null) {
            throw new I18NException("Dictionary entry forms can't be null");
        }
        this.one = one;
        this.many = many;
        this.zero = zero;
    }

    public PluralEntry2Form(String one, String many) {
        this(one, many, null);
    }

    @JsonCreator
    public PluralEntry2Form(
            @JsonProperty("one") String one,
            @JsonProperty("many") String many,
            @JsonProperty("zero") String zero,
            @JsonProperty("is_plural") boolean isPlural
    ) {
        this(one, many, zero);
        if (!isPlural) {
            throw new I18NException("is_plural property must be true");
        }
    }

    @JsonValue
    public JsonNode toJson() {
        ObjectNode tree = Dictionary.OBJECT_MAPPER.createObjectNode()
                .put("one", one)
                .put("many", many);

        if (zero != null) {
            tree.put("zero", zero);
        }

        tree.put("is_plural", true);

        return tree;
    }

    public String getOne() {
        return one;
    }

    public String getMany() {
        return many;
    }

    @Override
    public Optional<String> getZero() {
        return Optional.ofNullable(zero);
    }

    @Override
    public boolean isComplete() {
        return !one.isEmpty() && !many.isEmpty();
    }

    @Override
    public String toString() {
        return "PluralEntry2Form{" +
                "one='" + one + '\'' +
                ", many='" + many + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PluralEntry2Form that = (PluralEntry2Form) o;

        if (!one.equals(that.one)) {
            return false;
        }
        return many.equals(that.many);
    }

    @Override
    public int hashCode() {
        int result = one.hashCode();
        result = 31 * result + many.hashCode();
        return result;
    }
}
